package ch.frankel.blog.jaxb;

import static ch.frankel.blog.jaxb.SexType.MALE;
import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertTrue;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/**
 * Test class for JAXB marshalling unmarshalling.
 * 
 * @author Nicolas Frankel
 * @since 17.06.2009
 * @version 1.0
 */
public class JaxbTest {

	/**
	 * Test for marshalling a {@link PersonsType}.
	 * 
	 * @throws Exception
	 */
	@SuppressWarnings("deprecation")
	@Test
	public void testMarshalling() throws Exception {

		ObjectFactory factory = new ObjectFactory();

		PersonsType persons = factory.createPersonsType();

		PersonType person = factory.createPersonType();

		persons.getPerson().add(person);

		person.firstName = "Jo";
		person.lastName = "Dalton";
		person.birthDate = new Date(15, 0, 1);
		person.sex = MALE;

		JAXBContext context = JAXBContext.newInstance(PersonsType.class);

		Marshaller marshaller = context.createMarshaller();

		StringWriter writer = new StringWriter();

		marshaller.marshal(new JAXBElement<PersonsType>(new QName("uri",
				"persons"), PersonsType.class, persons), writer);

		StringReader reader = new StringReader(writer.getBuffer().toString());

		System.out.println(writer.getBuffer().toString());

		DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = dbFactory.newDocumentBuilder();
		Document doc = builder.parse(new InputSource(reader));

		XPathFactory xpathFactory = XPathFactory.newInstance();
		XPath xpath = xpathFactory.newXPath();

		assertEquals(xpath.evaluate("count(//person)", doc,
				XPathConstants.NUMBER), 1.0);

		Node personNode = (Node) xpath.evaluate("//person", doc,
				XPathConstants.NODE);

		assertEquals(xpath.evaluate("firstName/text()", personNode), "Jo");
		assertEquals(xpath.evaluate("lastName/text()", personNode), "Dalton");
		assertEquals(xpath.evaluate("sex/text()", personNode), MALE.value());
		// Cannot assert the time zone we'll be running into
		assertTrue(xpath.evaluate("birthDate/text()", personNode).startsWith(
				"1915-01-01"));
	}
}
